function [sus] = get_sus_matrix(freq, Gamma, peak_pos, g0_mech_cav, ...
    par)

    function y = chi_inv(n, spe_omega)
        y = Gamma(n)/2 - 1i*(spe_omega - ...
            peak_omega(n));
    end

    function y = chi_opt(w)
        y = 1/(par.opt.K/2 - 1i*(w + par.opt.det));
    end

    function y = kroneckerDelta(m,n)
        y = m==n;
    end 

Gamma = Gamma*2*pi;
omega = freq;
peak_omega = peak_pos*2*pi;

dim = size(peak_pos, 2)*2;
M = zeros(dim, dim);

eta = chi_opt(omega) - conj(chi_opt(-omega));

for m=1:dim
    for n=1:dim
        n_peak = ceil(n/2);
        m_peak = ceil(m/2);
        
        if rem(m,2)==1 && rem(n,2)==1
            M(m,n) = (chi_inv(n_peak,omega)*kroneckerDelta(m,n) + ...
                1i*par.opt.nc*eta*g0_mech_cav(n_peak)*...
                g0_mech_cav(m_peak))/sqrt(Gamma(n_peak));
        elseif rem(m,2)==0 && rem(n,2)==0
            M(m,n) = (conj(chi_inv(n_peak,-omega))*kroneckerDelta(m,n) + ...
                1i*par.opt.nc*eta*g0_mech_cav(n_peak)*...
                g0_mech_cav(m_peak))/sqrt(Gamma(n_peak));
        else
            M(m,n) = 1i*par.opt.nc*eta*g0_mech_cav(n_peak)...
                *g0_mech_cav(m_peak)/sqrt(Gamma(n_peak));
        end
    end
end

sus = inv(M);

end